//+------------------------------------------------------------------+
//|                                        super-signals-channel.mq4 |
//|                Copyright  2006, Nick Bilak, beluck[AT]gmail.com |
//+------------------------------------------------------------------+

#property copyright "Copyright  2006, Nick Bilak"
#property link      "http://www.forex-tsd.com/"

// hacked into a channel ind. by t_david sometime in early 2007

#property indicator_chart_window
#property indicator_buffers 4
#property indicator_color1 Red
#property indicator_width1 1
#property indicator_color2 Lime
#property indicator_width2 1
#property indicator_color3 Red
#property indicator_width3 1
#property indicator_color4 Lime
#property indicator_width4 1

extern int SignalGap = 4;
extern int ShowBars = 500;

extern bool Alert_1=true; //      

int dist=24;

double b1[];
double b2[];
double b3[];
double b4[];

int init()  {
   
   SetIndexStyle(0,DRAW_LINE,STYLE_SOLID,1);
   SetIndexStyle(1,DRAW_LINE,STYLE_SOLID,1);
   SetIndexStyle(2,DRAW_ARROW,STYLE_SOLID,1);
   SetIndexStyle(3,DRAW_ARROW,STYLE_SOLID,1);
   
   SetIndexBuffer(0,b1);
   SetIndexBuffer(1,b2);
   SetIndexBuffer(2,b3);
   SetIndexBuffer(3,b4);
   
   SetIndexArrow(2,234);
   SetIndexArrow(3,233);
   
   return(0);
}

int start() {
   
   int k,i,j,limit,hhb,llb;
   
   if (ShowBars >= Bars) ShowBars = Bars;
   
   for (i=0;i<ShowBars;i++)   {
   
      b1[i]=0;
      b2[i]=0;
      b3[i]=0;
      b4[i]=0;
      
      hhb = iHighest(Symbol(),0,MODE_HIGH,dist,i-dist/2);
      llb = iLowest(Symbol(),0,MODE_LOW,dist,i-dist/2);

      
      if (i==hhb)
         b3[i]=High[hhb]+SignalGap*Point;
      
      if (i==llb)
         b4[i]=Low[llb]-SignalGap*Point;
         
         b1[i]=High[hhb];//+SignalGap*Point;
         b2[i]=Low[llb];//-SignalGap*Point;
   
   }
   if(Alert_1){
      if(b3[1]!=0 && b3[1]!=EMPTY_VALUE){
         static int lt1=0;
            if(lt1!=Time[0]){
               lt1=Time[0];
               Alert("SSC ("+Symbol()+","+fTimeFrameName(Period())+"): DN , Bid="+DS(Bid));
            }
      }
      if(b4[1]!=0 && b4[1]!=EMPTY_VALUE){
         static int lt2=0;
            if(lt2!=Time[0]){
               lt2=Time[0];
               Alert("SSC ("+Symbol()+","+fTimeFrameName(Period())+"): UP , Bid="+DS(Bid));
            }         
      }      
   }
   return(0);
}

//+------------------------------------------------------------------+

string DS(double v){return(DoubleToStr(v, Digits));}

string fTimeFrameName(int arg){

   // fTimeFrameName();

   int v;
      if(arg==0){
         v=Period();
      }
      else{
         v=arg;
      }
      switch(v){
         case 0:
            return("0");
         case 1:
            return("M1");
         case 5:
            return("M5");                  
         case 15:
            return("M15");
         case 30:
            return("M30");             
         case 60:
            return("H1");
         case 240:
            return("H4");                  
         case 1440:
            return("D1");
         case 10080:
            return("W1");          
         case 43200:
            return("MN1");
         default:
            return("Wrong TimeFrame");          
      }
}

